package com.mmc.oms.dao.lease;

import com.mmc.oms.entity.lease.LeaseOrderDO;
import com.mmc.oms.entity.lease.LeaseOrderExpressDO;
import com.mmc.oms.entity.lease.LeaseRefundOrderDO;
import com.mmc.oms.entity.transtatus.TranStatusDicDO;
import com.mmc.oms.entity.uav.UavOrderDO;
import com.mmc.oms.model.qo.uav.UavOrderQO;
import org.apache.ibatis.annotations.Mapper;

import java.util.List;

/**
 * @Author LW
 * @date 2023/9/21 16:48
 * 概要：
 */
@Mapper
public interface LeaseOrderDao {
    void addOrder(LeaseOrderDO leaseOrderDO);

    void addAddress(LeaseOrderExpressDO leaseOrderExpressDO);

    LeaseOrderDO detail(Integer id);

    LeaseOrderExpressDO getLeaseOrderExpress(Integer id);

    void updateUavOrderStatus(Integer id, Integer code);

    void addLeaseRefundOrder(LeaseRefundOrderDO leaseRefundOrderDO);

    int countList(UavOrderQO uavOrderQO);

    List<LeaseOrderDO> list(UavOrderQO uavOrderQO);

    List<LeaseRefundOrderDO> getLeaseRefundOrder(List<Integer> ids);

    UavOrderDO detailByNo(String orderNo);

    void updateLeaseOrderExpress(LeaseOrderExpressDO leaseOrderExpressDO);

    List<TranStatusDicDO> statusList();

    void closeShowLeaseOrder(Integer id);

    List<LeaseOrderExpressDO> listLeaseOrderExpress(List<Integer> expressIds);

    void updateLeaseOrderProportion(Integer id, int proportion);

    LeaseRefundOrderDO selectGiveBackByOrderId(Integer id);
}
