package com.mmc.oms.model.dto.user;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * @Author small
 * @Date 2023/5/24 14:53
 * @Version 1.0
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
//@ApiModel(value = "com.mmc.csf.mall.dto.MallUserDTO", description = "用户信息DTO")
public class MallUserDTO implements Serializable {
    private static final long serialVersionUID = -2968237190830435082L;
    @ApiModelProperty("id")
    private Integer id;
    @ApiModelProperty("uid")
    private String uid;
    @ApiModelProperty("个人认证名字")
    private String userName;
    @ApiModelProperty("联系电话")
    private String phoneNum;
    @ApiModelProperty("小程序openid")
    private String openId;
    @ApiModelProperty("微信unionid")
    private String unionId;
    @ApiModelProperty("微信昵称")
    private String nickName;
    @ApiModelProperty("头像")
    private String headerImg;
    @ApiModelProperty("经度")
    private Double lon;
    @ApiModelProperty("纬度")
    private Double lat;
    @ApiModelProperty("注册端口")
    private String ports;
    @ApiModelProperty("备注")
    private String remark;
    @ApiModelProperty(value = "用户来源：0自然流，1海报，2抖音，3公众号，4社群，5招投标，默认0")
    private Integer source;
    @ApiModelProperty("渠道等级状态")
    private Integer channelAuthStatus;
    @ApiModelProperty("渠道等级标签")
    private Integer channelClass;
    @ApiModelProperty("渠道等级名称")
    private String tagName;
    @ApiModelProperty("注册时间")
    private Date createTime;
    @ApiModelProperty("更新时间")
    private Date updateTime;
    @ApiModelProperty(value = "实名认证状态（0未通过，1通过）")
    private Integer realAuthStatus;
    @ApiModelProperty(value = "企业认证状态（0未通过，1通过）")
    private Integer entAuthStatus;
    @ApiModelProperty("企业名称")
    private String entName;
    @ApiModelProperty("法大大电子签章认证状态(0未通过，1通过)")
    private Integer entVerifyStatus;
    @ApiModelProperty("实名认证时间")
    private Date realAuthTime;
    @ApiModelProperty("企业认证时间")
    private Date entAuthTime;
    @ApiModelProperty("电子签章认证时间")
    private Date entVerifyTime;

    @ApiModelProperty(value = "上级推荐人id")
    private Integer upReferralId;
    @ApiModelProperty(value = "上级推荐人的uid(name)")
    private String upReferralUidAndName;
    @ApiModelProperty(value = "推荐伙伴数量")
    private Integer lowerReferralCount;
    @ApiModelProperty("相关运营id")
    private Integer operateId;
    @ApiModelProperty("相关运营Name")
    private String operateName;
    @ApiModelProperty("相关销售id")
    private Integer saleId;
    @ApiModelProperty("相关销售Name")
    private String saleName;

    @ApiModelProperty("小程序相关运营id")
    private Integer mallOperator;
    @ApiModelProperty("小程序相关运营名字")
    private String mallOperatorName;
    @ApiModelProperty("小程序相关运营uid")
    private String mallOperatorUID;
    @ApiModelProperty("小程序相关销售id")
    private Integer mallSaleManager;
    @ApiModelProperty("小程序相关销售uid")
    private String mallSaleManagerUID;
    @ApiModelProperty("小程序相关销售名字")
    private String mallSaleManagerName;
    @ApiModelProperty("上级渠道名称")
    private String superiorChannelName;
    @ApiModelProperty(value = "开户银行")
    private String accountBank;
    @ApiModelProperty(value = "开户姓名")
    private String accountName;
    @ApiModelProperty(value = "银行卡号")
    private String bankCardNumber;
    @ApiModelProperty(value = "支行")
    private String branch;
}
