package com.mmc.oms.model.dto.flyer;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @Author small
 * @Date 2023/5/24 15:06
 * @Version 1.0
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class FlyerScenesAuthDTO implements Serializable {
    private static final long serialVersionUID = 66032902942031710L;
    @ApiModelProperty("飞手id")
    private Integer id;
    @ApiModelProperty(value = "商务礼仪认证")
    private Integer protocolAuth;
    @ApiModelProperty(value = "电力巡检认证状态，0未认证，1通过，2未通过")
    private Integer electricAuth;
    @ApiModelProperty(value = "航空测绘认证状态，0未认证，1通过，2未通过", hidden = true)
    @JsonIgnore
    private Integer aviationAuth;
    @ApiModelProperty(value = "应急保障认证状态，0未认证，1通过，2未通过", hidden = true)
    @JsonIgnore
    private Integer emergencyAuth;
    @ApiModelProperty(value = "value = 监察巡检认证状态，0未认证，1通过，2未通过", hidden = true)
    @JsonIgnore
    private Integer superviseAuth;
    @ApiModelProperty(value = "通用认证状态，0未认证，1通过，2未通过")
    private Integer universalAuth;
    @ApiModelProperty(value = "油气巡检认证状态，0未认证，1通过，2未通过")
    private Integer oilGasAuth;
    @ApiModelProperty(value = "演示认证状态，0未认证，1通过，2未通过")
    private Integer demoAuth;
    @ApiModelProperty(value = "航空测绘外业状态，0未认证，1通过，2未通过")
    private Integer aviationOutAuth;
    @ApiModelProperty(value = "航空测绘内业状态，0未认证，1通过，2未通过")
    private Integer aviationInAuth;
    @ApiModelProperty(value = "指挥车认证状态，0未认证，1通过，2未通过")
    private Integer commandAuth;
    @ApiModelProperty(value = "天目将软件认证状态，0未认证，1通过，2未通过")
    private Integer tmjAuth;
}
