package com.mmc.csf.release.controller;

import com.mmc.csf.common.util.page.PageResult;
import com.mmc.csf.common.util.web.ResultBody;
import com.mmc.csf.release.dao.gambit.GambitDao;
import com.mmc.csf.release.entity.forum.ForumDynamicUserDO;
import com.mmc.csf.release.entity.gambit.ForumAttentionDO;
import com.mmc.csf.release.forum.vo.CommentVO;
import com.mmc.csf.release.forum.vo.DynamicVO;
import com.mmc.csf.release.forum.vo.ReplyToAReviewVO;
import com.mmc.csf.release.gambit.dto.ForumGambitDTO;
import com.mmc.csf.release.gambit.dto.PostingLeaderboardDTO;
import com.mmc.csf.release.gambit.qo.ForumGambitQO;
import com.mmc.csf.release.gambit.qo.PostingLeaderboardQO;
import com.mmc.csf.release.gambit.vo.ForumGambitVO;
import com.mmc.csf.release.service.DynamicService;
import io.swagger.annotations.*;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * @Author LW
 * @date 2023/5/15 10:29 概要：动态信息控制层
 */
@Api(tags = {"web-小程序-论坛社区-模块"})
@RestController
@RequestMapping("/dynamic")
public class DynamicController extends BaseController {

    @Resource
    private DynamicService dynamicService;

    @ApiOperation(value = "动态发布")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("/publish")
    public ResultBody publishDynamic(@RequestBody DynamicVO dynamicVO, HttpServletRequest request) {
        return dynamicService.insertDynamic(dynamicVO, this.getUserLoginInfoFromRedis(request).getUserAccountId(), request);
    }

    @ApiOperation(value = "点赞或取消点赞")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("/likeOrCancel")
    public ResultBody likeOrCancel(
            HttpServletRequest request, @ApiParam(value = "动态id") @RequestParam Integer dynamicId) {
        return dynamicService.likeDynamic(
                this.getUserLoginInfoFromRedis(request).getUserAccountId(), dynamicId);
    }

    @ApiOperation(value = "update-评论动态/回复")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("/comment")
    public ResultBody commentDynamic(@RequestBody CommentVO commentVO, HttpServletRequest request) {
        return dynamicService.commentDynamic(commentVO, this.getUserLoginInfoFromRedis(request).getUserAccountId(), request);
    }

    @ApiOperation(value = "对评论/及回复的点赞或者取消")
    @GetMapping("/reviewLikes")
    public ResultBody reviewLikes(@RequestParam Integer id,HttpServletRequest request,@RequestParam Boolean status){
        Integer userAccountId = this.getUserLoginInfoFromRedis(request).getUserAccountId();
        return dynamicService.reviewLikes(id,userAccountId,status);
    }


    /* @ApiOperation(value = "删除评论")
     @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
     @DeleteMapping("/removeComment")
     public ResultBody removeComment(@RequestParam Integer id) {
         return dynamicService.deleteComment(id);
     }
 */
    @ApiOperation(value = "动态详情")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = DynamicVO.class)})
    @GetMapping("/dynamicDetails")
    public ResultBody<DynamicVO> dynamicDetails(@RequestParam Integer dynamicId, HttpServletRequest request,
                                                @RequestParam(required = true) Integer userAccountId) {

        return dynamicService.dynamicDetails(dynamicId, userAccountId, request);
    }

    @ApiOperation(value = "动态列表")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = DynamicVO.class)})
    @GetMapping("/dynamicList")
    public ResultBody<DynamicVO> dynamicList(
            @RequestParam Integer pageNo, @RequestParam Integer pageSize, HttpServletRequest request,
            @RequestParam(required = false) Integer gambitId, @RequestParam(required = false) Integer id,
            @RequestParam(required = false) Integer userAccountId,
            @RequestParam(required = false) String description,
            @RequestParam(required = false) List<String> gambitName) {
        return ResultBody.success(
                dynamicService.dynamicList(
                        pageNo, pageSize, this.getUserLoginInfoFromRedis(request).getUserAccountId(), request,gambitId,id,userAccountId,description,gambitName));
    }


    @ApiOperation(value = "new-小程序-返回最新5条带动态的图片")
    @GetMapping("/recentNews")
    public ResultBody<ForumDynamicUserDO> recentNewsList(@ApiParam(value = "用户id" ) @RequestParam(required = false) Integer userAccountId){
        return dynamicService.recentNewsList(userAccountId);
    }

    @ApiOperation(value = "new-小程序-话题列表")
    @PostMapping("/appGambitList")
    public ResultBody<ForumGambitDTO> appGambitList(@RequestBody ForumGambitQO forumGambitQO){
        return ResultBody.success(dynamicService.appGambitList(forumGambitQO));
    }

    @ApiOperation(value = "发贴排行榜")
    @PostMapping("/postingLeaderboard")
    public ResultBody<PostingLeaderboardDTO> postingLeaderboard(@RequestBody PostingLeaderboardQO postingLeaderboardQO){
        return ResultBody.success(dynamicService.postingLeaderboard(postingLeaderboardQO));
    }


    @ApiOperation(value = "new飞手列表是否关注")
    @GetMapping("/getPilot")
    public ResultBody<ForumAttentionDO> getPilot(@RequestParam Integer userAccountId){
        return ResultBody.success(dynamicService.getPilot(userAccountId));
    }




}
