package com.mmc.csf.release.industry;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @Author small
 * @Date 2023/8/18 13:39
 * @Version 1.0
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
public class InspectionDTO implements Serializable {
    private static final long serialVersionUID = 8316723266007785996L;
    @ApiModelProperty(value = "id")
    private Integer id;
    @ApiModelProperty(value = "服务编号")
    private String inspectionNo;
    @ApiModelProperty(value = "服务名称")
    private String inspectionName;
    @ApiModelProperty(value = "行业类型id")
    private Integer industryTypeId;
    @ApiModelProperty(value = "服务图标")
    private String inspectionImg;
    @ApiModelProperty(value = "服务描述")
    private String inspectionDescription;
    @ApiModelProperty(value = "销售状态，0停售，1在售")
    private Integer saleState;
    @ApiModelProperty(value = "案例图")
    private String caseImg;
    @ApiModelProperty(value = "案例视频")
    private String caseVideo;
    @ApiModelProperty(value = "创建时间")
    private Date createTime;
    @ApiModelProperty(value = "团队服务列表")
    List<CompanyInspectionDTO> companyInspectionDTOS;
}
