package com.mmc.csf.release.entity;

import com.mmc.csf.infomation.vo.RequirementsInfoVO;
import com.mmc.csf.release.model.group.Insert;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;

/**
 * @author: zj
 * @Date: 2023/5/18 15:11
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class RequirementsInfoDO implements Serializable {
    private static final long serialVersionUID = -1811974173256250060L;
    private Integer id;
    private Integer requirementTypeId;
    private Integer userAccountId;
    private Integer provinceCode;
    private Integer cityCode;
    private Integer districtCode;
    private String publishName;
    private String publishPhone;
    private String requireDescription;
    private Integer deleted;
    private Integer solved;
    private Date createTime;
    private Date updateTime;

    public RequirementsInfoVO buildRequirementsInfoVO(){
        return RequirementsInfoVO.builder().id(this.id).requirementTypeId(this.requirementTypeId).userAccountId(this.userAccountId).publishName(this.publishName)
                .publishPhone(this.publishPhone).requireDescription(this.requireDescription).solved(this.solved).createTime(this.createTime).updateTime(this.updateTime).build();
    }

    public RequirementsInfoDO(RequirementsInfoVO requirementsInfoVO){
        this.id = requirementsInfoVO.getId();
        this.requirementTypeId = requirementsInfoVO.getRequirementTypeId();
        this.userAccountId = requirementsInfoVO.getUserAccountId();
        this.publishName = requirementsInfoVO.getPublishName();
        this.publishPhone = requirementsInfoVO.getPublishPhone();
        this.requireDescription = requirementsInfoVO.getRequireDescription();
        this.provinceCode = requirementsInfoVO.getProvinceCode();
        this.cityCode = requirementsInfoVO.getCityCode();
        this.districtCode = requirementsInfoVO.getDistrictCode();
    }

}
