package com.mmc.csf.infomation.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author MMC_hzj
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class TenderInfoDTO implements Serializable {
    private static final long serialVersionUID = -8404011575132191740L;
    @ApiModelProperty(value = "id")
    private Integer id;
    @ApiModelProperty(value = "招标快讯id")
    private Integer tenderNewsId;
    @ApiModelProperty(value = "招标快讯内容序号")
    private String tenderInfoNo;
    @ApiModelProperty(value = "招标快讯内容")
    private String tenderContent;
    @ApiModelProperty(value = "价格")
    private BigDecimal tenderPrice;
    @ApiModelProperty(value = "生成时间")
    private Date createTime;
}
