package com.mmc.csf.release.controller;

import com.mmc.csf.common.util.group.Create;
import com.mmc.csf.common.util.web.ResultBody;
import com.mmc.csf.release.forum.vo.DynamicVO;
import com.mmc.csf.release.service.TaskService;
import com.mmc.csf.release.task.qo.TaskServiceQo;
import com.mmc.csf.release.task.vo.OrderTaskVO;
import com.mmc.csf.release.task.vo.TaskServiceDetailVO;
import com.mmc.csf.release.task.vo.TaskServiceVO;
import io.swagger.annotations.*;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;

/**
 * @Author LW
 * @date 2023/5/17 13:55
 * 概要：
 */
@Api(tags = {"web-小程序-作业服务-模块"})
@RestController
@RequestMapping("/work")
public class TaskController {
    @Resource
    private TaskService taskService;

    @ApiOperation(value = "作业服务列表")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = TaskServiceVO.class)})
    @PostMapping("/queryTaskServiceList")
    public ResultBody queryTaskServiceList(@RequestBody TaskServiceQo taskServiceQo) {
        return ResultBody.success(taskService.queryTaskServiceList(taskServiceQo));
    }

    @ApiOperation(value = "获取服务信息")
    @ApiResponses({ @ApiResponse(code = 200, message = "OK", response = TaskServiceDetailVO.class) })
    @GetMapping("selectInspection")
    public ResultBody<TaskServiceDetailVO> getInspectionById(@ApiParam(value = "服务ID", required = true) @RequestParam Integer id){
        return taskService.getInspectionById(id);
    }

    @ApiOperation(value = "预约服务")
    @ApiResponses({ @ApiResponse(code = 200, message = "OK", response = ResultBody.class) })
    @PostMapping("reservationService")
    public ResultBody reservationService(@Validated(Create.class) @RequestBody OrderTaskVO orderTaskVO) {
        return taskService.reservationService(orderTaskVO);
    }

}
