package com.mmc.csf.release.dao;

import com.mmc.csf.infomation.qo.BannerInfoQO;
import com.mmc.csf.infomation.qo.ModuleInfoQO;
import com.mmc.csf.release.entity.module.BannerInfoDO;
import com.mmc.csf.release.entity.module.ModuleInfoDO;
import org.apache.ibatis.annotations.Mapper;

import java.util.List;

/**
 * @Author small
 * @Date 2023/5/23 14:24
 * @Version 1.0
 */
@Mapper
public interface ModuleInfoDao {
    void insertModuleInfo(ModuleInfoDO moduleInfoDO);

    void updateModuleInfo(ModuleInfoDO moduleInfoDO);

    void removeModuleInfo(Integer id);

    void updateModuleInfoRemark(Integer id, String remark);

    int countListModuleInfoPage(ModuleInfoQO param);

    List<ModuleInfoDO> listModuleInfoPage(ModuleInfoQO param);

    int countListBannerInfoPage(BannerInfoQO param);

    List<BannerInfoDO> listBannerInfoPage(BannerInfoQO param);

    void removeBannerInfo(Integer id);

    int getCountBannerInfoOfModule(Integer moduleId);

    void insertBannerInfo(BannerInfoDO bannerInfoDO);

    void updateBannerInfo(BannerInfoDO bannerInfoDO);

    int getCountSameNameOfModuleInfo(Integer moduleType, String moduleName);

    int getCountSameNameOfBannerInfo(Integer moduleId, String bannerName);

    int getCountSameNameNotItSelfOfModule(Integer id, Integer moduleType, String moduleName);

    int getCountSameNameNotItSelfOfBanner(Integer id, Integer moduleId, String bannerName);

    List<BannerInfoDO> listBannerImg(String moduleCode);

    void removeBanners(Integer id);

    int getCountSameCode(String moduleCode);

    int getCountSameCodeOfItSelf(Integer id, String moduleCode);

    void batchRemoveBannerInfo(List<Integer> list);
}
