package com.mmc.csf.infomation.vo;

import com.mmc.csf.release.model.group.Create;
import com.mmc.csf.release.model.group.Update;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotBlank;

/**
 * @Author small
 * @Date 2023/8/18 14:30
 * @Version 1.0
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class PilotAbilityVO {

    private Integer id;

    @ApiModelProperty(value = "能力id不能为空", example = "5", required = true)
    @NotBlank(message = "能力id不能为空", groups = {Create.class, Update.class})
    private Integer abilityId;

    @ApiModelProperty(value = "能力不能为空", example = "道路检测", required = true)
    @NotBlank(message = "能力名称不能为空", groups = {Create.class, Update.class})
    private String abilityName;

    @ApiModelProperty(value = "飞手认证id", hidden = true)
    private Integer pilotCertificationId;
}

