package com.mmc.csf.release.service;

import com.mmc.csf.common.util.web.ResultBody;
import com.mmc.csf.infomation.dto.*;
import com.mmc.csf.infomation.qo.IndustryCaseQO;
import com.mmc.csf.infomation.vo.*;

import javax.servlet.http.HttpServletRequest;

/**
 * @author: zj
 * @Date: 2023/5/18 14:29
 */
public interface RequirementsService {
    /**
     * 需求类型列表
     *
     * @return
     */
    ResultBody listType(Integer id);

    /**
     * 需求发布
     *
     * @param requirementsInfoVO
     * @param request
     * @return
     */
    ResultBody publish(RequirementsInfoVO requirementsInfoVO, HttpServletRequest request);

    /**
     * 解决需求
     *
     * @param requirementsInfoId
     * @param userAccountId
     * @return
     */
    ResultBody solveRequire(Integer requirementsInfoId, Integer userAccountId);

    /**
     * 需求发布列表
     *
     * @param industryCaseQO
     * @param request
     * @return
     */
    ResultBody listPublishPage(IndustryCaseQO industryCaseQO, HttpServletRequest request);

    /**
     * 删除需求
     *
     * @param requirementsInfoId
     * @param userAccountId
     * @return
     */
    ResultBody deleteRequire(Integer requirementsInfoId, Integer userAccountId);

    ResultBody updatePublish(RequirementsInfoVO requirementsInfoVO, HttpServletRequest request);

    ResultBody deletePublish(Integer id, Integer userAccountId);

    ResultBody appPublishList();

    ResultBody detailPublish(Integer id, HttpServletRequest request, Integer userAccountId);

    ResultBody backDetailPublish(Integer id, HttpServletRequest request, Integer userAccountId);

    ResultBody publishService(ServiceRequirementsVO serviceRequirementsVO, HttpServletRequest request);

    ResultBody<RequirementsInfoVO> myPublish(Integer userAccountId);

    ResultBody<RequirementsInfoVO> grabTheOrder(GrabTheOrderVO grabTheOrderVO, HttpServletRequest request);

    ResultBody arriveAtTheScene(ServiceArriveSceneVO serviceArriveSceneVO);

    ResultBody<ServiceArriveSceneDTO> arriveAtTheSceneDetails(Integer requirementsInfoId, Integer userAccountId);

    ResultBody fulfilATask(ServiceFulfilATaskVO fulfilATaskVO);

    ResultBody<ServiceFulfilATaskDTO> fulfilATaskDetails(Integer requirementsInfoId, Integer userAccountId);

    ResultBody settleAccounts(ServiceSettleAccountsVO settleAccountsVO);


    ResultBody<ServiceSettleAccountsDTO> settleAccountsDetails(Integer requirementsInfoId, Integer userAccountId);

    ResultBody evaluate(ServiceEvaluateVO evaluateVO);

    ResultBody<ServiceEvaluateDTO> evaluateDetails(Integer requirementsInfoId, Integer userAccountId);

    ResultBody publisherNumber(GetOrderNumberVO getOrderNumberVO, HttpServletRequest request);

    ResultBody<RequirementsInfoVO> myPreempt(Integer userAccountId);

    ResultBody droneFlyerCancel(Integer requirementsInfoId, Integer userAccountId);

    ResultBody publisherCancel(Integer requirementsInfoId, Integer userAccountId);

    ResultBody cancelAll(Integer requirementsInfoId, Integer userAccountId);


    ResultBody updatePublisherCancel(RequirementsAmountVO amountVO, HttpServletRequest request);

    ResultBody<FlowDictionaryDTO> flowDictionary();

    ResultBody confirmSettlement(Integer userAccountId);
}
