package com.mmc.csf.release.feign;

import com.mmc.csf.infomation.dto.UserAccountSimpleDTO;
import com.mmc.csf.release.feign.hystrix.UserAppApiHystrix;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * @author: zj
 * @Date: 2023/5/18 17:06
 */
//@FeignClient(name = "cms-svc", fallback = UserAppApiHystrix.class)
@FeignClient(url = "${iuav.userapp.url}", name = "cms-svc", fallback = UserAppApiHystrix.class)
public interface UserAppApi {
    /**
     * 根据用户id获取基本信息
     * @param userAccountId
     * @return
     */
    @RequestMapping(value = "/userapp/user-account/feignGetUserSimpleInfo", method = RequestMethod.GET)
    public UserAccountSimpleDTO feignGetUserSimpleInfo(@RequestParam Integer userAccountId);

    /**
     * 根据地区信息查询用户id
     * @param provinceCode
     * @param cityCode
     * @param districtCode
     * @return
     */
    @GetMapping("/userapp/user-account/feignListUserAccountIds")
    List<Integer> feignListUserAccountIds(@RequestParam Integer provinceCode, @RequestParam Integer cityCode, @RequestParam Integer districtCode);
}
