package com.mmc.csf.release.service;

import com.mmc.csf.common.util.page.PageResult;
import com.mmc.csf.common.util.web.ResultBody;
import com.mmc.csf.release.task.qo.TaskServiceQo;
import com.mmc.csf.release.task.vo.OrderTaskVO;
import com.mmc.csf.release.task.vo.TaskServiceDetailVO;
import com.sun.org.apache.regexp.internal.RE;

/**
 * @Author LW
 * @date 2023/5/17 13:56
 * 概要：
 */
public interface TaskService {
    /**
     * 查询任务服务列表
     *
     * @param taskServiceQo 任务服务
     * @return {@link ResultBody}
     */
    PageResult queryTaskServiceList(TaskServiceQo taskServiceQo);

    /**
     * 通过id获取服务详情
     *
     * @param id id
     * @return {@link ResultBody}<{@link TaskServiceDetailVO}>
     */
    ResultBody<TaskServiceDetailVO> getInspectionById(Integer id);

    /**
     * 预订服务
     *
     * @param orderTaskVO 订单任务
     * @return {@link ResultBody}
     */
    ResultBody reservationService(OrderTaskVO orderTaskVO);

    /**
     * 列出所有行业
     *
     * @return {@link ResultBody}
     */
    ResultBody listAllIndustry();

    /**
     * 列出所有应用程序类型
     *
     * @return {@link ResultBody}
     */
    ResultBody listAllAppType();

    /**
     * 列出所有任务服务
     *
     * @return {@link ResultBody}
     */
    ResultBody listAllTaskService();
}
