package com.mmc.csf.release.task.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @Author LW
 * @date 2022/4/22 15:33
 * 概要：
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@ApiModel(value = "com.mmc.csf.model.dto.EvaluateInfoVO",description = "评论列表DTO")
public class EvaluateInfoVO implements Serializable {
    @ApiModelProperty(value = "id")
    private Integer id;
    @ApiModelProperty(value = "内容")
    private String content;
    @ApiModelProperty(value = "评论图片")
    private String contentImgs;
    @ApiModelProperty(value = "评论视频")
    private String contentVideo;
    @ApiModelProperty(value = "星级 0-5")
    private Integer star;
    @ApiModelProperty(value = "是否带图 0：带图 1：不带图")
    private Integer img;
    @ApiModelProperty(value = "评价类型：0：好评 1：差评")
    private Integer type;
}
