package com.mmc.csf.web.dto;

import com.alibaba.fastjson.JSONArray;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * @Author LW
 * @date 2022/4/21 19:56
 * 概要：
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@ApiModel(value = "com.mmc.csf.model.dto.WebsiteDTO", description = "网点信息")
public class WebsiteDTO implements Serializable {
    @ApiModelProperty(value = "id")
    private Integer id;
    @ApiModelProperty(value = "省编码")
    private String adCode;
    @ApiModelProperty(value = "省市")
    private String province;
    @ApiModelProperty(value = "地标信息")
    private JSONArray location;
    @ApiModelProperty(value = "创建时间")
    private Date createTime;

}
