package com.mmc.csf.release.service.impl;

import com.mmc.csf.common.util.page.PageResult;
import com.mmc.csf.common.util.web.ResultBody;
import com.mmc.csf.config.IsNullConvertZeroUtil;
import com.mmc.csf.infomation.dto.ServiceOrderFormDTO;
import com.mmc.csf.infomation.dto.ServiceOrderFormDetailsDTO;
import com.mmc.csf.infomation.qo.ServiceOrderQO;
import com.mmc.csf.release.auth.dto.LoginSuccessDTO;
import com.mmc.csf.release.dao.BackRequirementsDao;
import com.mmc.csf.release.entity.requirements.ServiceOrderFormDO;
import com.mmc.csf.release.entity.requirements.ServiceOrderFormDetailsDO;
import com.mmc.csf.release.service.BackRequirementsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @Author small
 * @Date 2023/8/29 10:20
 * @Version 1.0
 */
@Service
public class BackRequirementsServiceImpl implements BackRequirementsService {

    @Autowired
    private BackRequirementsDao backRequirementsDao;

    @Override
    public PageResult serviceOrderFormList(ServiceOrderQO param, LoginSuccessDTO userLoginInfoFromRedis) {
        int count = backRequirementsDao.countService(param);
        if (count == 0) {
            return PageResult.buildPage(param.getPageNo(), param.getPageSize(), count);
        }
        Integer pageNo = param.getPageNo();
        param.buildCurrentPage();
        List<ServiceOrderFormDO> serviceOrderFormDOS = backRequirementsDao.serviceOrderFormList(param);
        List<ServiceOrderFormDTO> collect = serviceOrderFormDOS.stream().map(ServiceOrderFormDO::buildServiceOrderForm).collect(Collectors.toList());
        return PageResult.buildPage(pageNo, param.getPageSize(), count, collect);
    }


    @Override
    public ResultBody serviceOrderFormDetails(Integer requirementsInfoId, LoginSuccessDTO userLoginInfoFromRedis) {
        ServiceOrderFormDetailsDO orderFormDetailsDO = backRequirementsDao.serviceOrderFormDetails(requirementsInfoId);
        ServiceOrderFormDetailsDTO serviceOrderFormDetailsDTO = orderFormDetailsDO.buildOrderFormDetails();
        IsNullConvertZeroUtil.checkIsNull(serviceOrderFormDetailsDTO);
        return ResultBody.success(serviceOrderFormDetailsDTO);
    }
}
