package com.mmc.csf.release.entity.requirements;

import com.alibaba.fastjson.annotation.JSONField;
import com.mmc.csf.infomation.dto.ServiceSettleAccountsDTO;
import com.mmc.csf.infomation.vo.ServiceSettleAccountsVO;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @Author small
 * @Date 2023/8/18 21:24
 * @Version 1.0
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class ServiceSettleAccountsDO implements Serializable {

    private static final long serialVersionUID = -447951390213113317L;
    private Integer id;

    @ApiModelProperty(value = "订单金额", example = "100")
    private BigDecimal orderAmount;

    @ApiModelProperty(value = "备注", example = "项目延期")
    private String remark;

    @ApiModelProperty(value = "需求id", example = "83")
    private Integer requirementsInfoId;

    @ApiModelProperty(value = "结算的用户id", example = "1", hidden = true)
    private Integer userAccountId;

    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;

    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date updateTime;


    public ServiceSettleAccountsDO(ServiceSettleAccountsVO accountsVO) {
        this.id = accountsVO.getId();
        this.orderAmount = accountsVO.getOrderAmount();
        this.remark = accountsVO.getRemark();
        this.requirementsInfoId = accountsVO.getRequirementsInfoId();
        this.userAccountId = accountsVO.getUserAccountId();

    }

    public ServiceSettleAccountsDTO buildServiceSettleAccountsDTO() {
        return ServiceSettleAccountsDTO.builder()
                .id(this.id)
                .orderAmount(this.orderAmount)
                .remark(this.remark)
                .requirementsInfoId(this.requirementsInfoId)
                .userAccountId(this.userAccountId)
                .createTime(this.createTime)
                .updateTime(this.updateTime)
                .build();
    }
}
