package com.mmc.csf.release.gambit.dto;

import com.mmc.csf.release.model.group.Create;
import com.mmc.csf.release.model.group.Update;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * @Author small
 * @Date 2023/9/13 17:57
 * @Version 1.0
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class ForumGambitDTO {

    @NotNull(message = "话题id不能为空",groups = {Update.class})
    private Integer id;

    @ApiModelProperty(value = "话题名称",example = "深圳暴雨")
    @NotBlank(message = "话题不能为空",groups = {Create.class, Update.class})
    private String gambitName;

    @ApiModelProperty(value = "话题图标",example = "http:")
    @NotBlank(message = "话题图标不能为空",groups = {Create.class,Update.class})
    private String gambitIcon;

    @ApiModelProperty(value = "话题封面",example = "http:")
    @NotBlank(message = "话题封面不能为空",groups = {Create.class,Update.class})
    private String gambitCover;

    @ApiModelProperty(value = "话题属性",example = "话题属性 1普通 2热门 3推荐 ")
    @NotNull(message = "话题属性不能为空")
    private Integer gambitProperty;

    @ApiModelProperty(value = "发贴用户",example = "1",hidden = true)
    private Integer userAccountId;

    @ApiModelProperty(value = "贴子数",example = "2")
    private Integer postCount;

    @ApiModelProperty(value = "话题参与讨论数量",example = "1")
    private Integer discussionCount;


}
