package com.mmc.csf.infomation.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @Author small
 * @Date 2023/8/25 18:45
 * @Version 1.0
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
public class FlowDictionaryAndTimeDTO implements Serializable {


    @ApiModelProperty(value = "发布成功", example = "发布成功")
    private ReleaseSuccessDTO releaseSuccess;

    //抢单
    @ApiModelProperty(value = "抢单", example = "抢单")
    private RequirementsServiceDTO requirementsServiceDTO;

    //抵达现场地址
    // service_arrive_scene
    @ApiModelProperty(value = "抵达现场", example = "抵达现场")
    private ServiceArriveSceneDTO serviceArriveSceneDTO;

    //完成任务
    //    service_fulfil_a_task
    @ApiModelProperty(value = "完成任务", example = "完成任务")
    private ServiceFulfilATaskDTO serviceFulfilATaskDTO;

    //结算
    //service_settle_accounts
    @ApiModelProperty(value = "结算", example = "结算")
    private ServiceSettleAccountsDTO serviceSettleAccountsDTO;

    //评价
    //       service_evaluate
    @ApiModelProperty(value = "评价", example = "评价")
    private ServiceEvaluateDTO serviceEvaluateDTO;

    @ApiModelProperty(value = "修改任务佣金", example = "修改任务佣金")
    private RequirementsAmountUpdateDTO amountUpdate;
}
