package com.mmc.csf.release.entity;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.mmc.csf.web.dto.WebsiteDTO;
import com.mmc.csf.web.dto.WebsiteRangeDTO;
import com.mmc.csf.web.vo.LocationVO;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @Author LW
 * @date 2022/4/21 20:09
 * 概要：
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class WebsiteInfoDO implements Serializable {
    private Integer id;
    private String adCode;
    private String province;
    private String location;
    private Date createTime;
    private Date updateTime;

    public WebsiteDTO buildWebsiteDTO() {
        JSONArray json = (JSONArray)JSONObject.parse(this.location);
        return WebsiteDTO.builder()
                .id(this.id)
                .adCode(this.adCode)
                .province(this.province)
                .location(json)
                .createTime(this.createTime)
                .build();
    }

    public WebsiteRangeDTO buildWebsiteRangeDTO() {
        List<LocationVO> list = JSONArray.parseArray(this.location, LocationVO.class);
        return WebsiteRangeDTO.builder()
                .id(this.id)
                .province(this.province)
                .adCode(this.adCode)
                .locationList(list)
                .build();
    }

}
