package com.mmc.csf.infomation.qo;

import com.mmc.csf.release.model.group.Page;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @Author small
 * @Date 2023/5/23 14:22
 * @Version 1.0
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
//@ApiModel(value = "com.mmc.csf.model.qo.BannerInfoQO", description = "banner查询QO")
public class BannerInfoQO implements Serializable {
    private static final long serialVersionUID = 7376276027677051853L;
    @ApiModelProperty(value = "关键字")
    private String keyword;
    @ApiModelProperty(value = "所属产品")
    private Integer moduleType;
    @ApiModelProperty(value = "宣传模块id")
    private Integer moduleId;
    @ApiModelProperty(value = "页码", required = true)
    @NotNull(message = "页码不能为空", groups = Page.class)
    @Min(value = 1, groups = Page.class)
    private Integer pageNo;
    @ApiModelProperty(value = "每页显示数", required = true)
    @NotNull(message = "每页显示数不能为空", groups = Page.class)
    @Min(value = 1, groups = Page.class)
    private Integer pageSize;

    public void buildCurrentPage() {
        this.pageNo = (pageNo - 1) * pageSize;
    }
}
