package com.mmc.csf.release.entity.requirements;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.mmc.csf.config.IsNullConvertZero;
import com.mmc.csf.infomation.vo.RequirementsInfoVO;
import com.mmc.csf.infomation.vo.ServiceRequirementsEditVO;
import com.mmc.csf.release.model.group.Insert;
import com.mmc.csf.release.model.group.Update;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author: zj
 * @Date: 2023/5/18 15:11
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class RequirementsInfoDO implements Serializable {
    private static final long serialVersionUID = -1811974173256250060L;
    private Integer id;
    private Integer requirementTypeId;
    private Integer userAccountId;
    private Integer provinceCode;
    private Integer cityCode;
    private Integer districtCode;
    private String publishName;
    private String publishPhone;
    private String requireDescription;
    private Integer deleted;
    //是否解决
    private Boolean solved;
    private Date createTime;
    private Date updateTime;
    @ApiModelProperty(value = "任务标题", example = "任务标题001", required = true)
    @NotBlank(message = "任务标题不能为空", groups = {Insert.class, Update.class})
    @Size(max = 15, message = "任务标题限制15个字")
    private String taskTitle;

    @ApiModelProperty(value = "任务开始时间", example = "2023-07-25", required = true)
    @NotNull(message = "任务开始时间不能为空", groups = {Insert.class, Update.class})
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private String taskStartTime;

    @ApiModelProperty(value = "任务结束时间", example = "2023-07-26", required = true)
    @NotNull(message = "任务开始时间不能为空", groups = {Insert.class, Update.class})
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private String taskEndTime;

    @ApiModelProperty(value = "任务地址", example = "广东省深圳市", required = true)
    @NotBlank(message = "任务地址不能为空", groups = {Insert.class, Update.class})
    private String taskAddress;


    @ApiModelProperty(value = "任务经度", example = "23.344324", required = true)
    @NotNull(message = "任务经度不能为空", groups = {Insert.class, Update.class})
    private Double longitude;

    @ApiModelProperty(value = "任务纬度", example = "44.344324", required = true)
    @NotNull(message = "任务纬度不能为空", groups = {Insert.class, Update.class})
    private Double latitude;


    @ApiModelProperty(value = "描述图片", example = "http://,http://", required = false)
    private String requireUrl;


    @ApiModelProperty(value = "类型名称")
    private String requirementTypeName;

    @ApiModelProperty(value = "发布者订单编号")
    private String publisherNumber;

    @ApiModelProperty(value = "订单级别", example = "订单级别", required = true)
    @NotNull(message = "订单级别", groups = {Insert.class})
    private String orderLevel;
    @ApiModelProperty(value = "服务id", example = "服务id", required = true)
    private Integer serviceId;
    @ApiModelProperty(value = "服务名称", example = "服务名称")
    private String serviceName;
    @ApiModelProperty(value = "发布者支付总金额", example = "发布者支付总金额")
    @IsNullConvertZero
    private BigDecimal totalAmount;
    @ApiModelProperty(value = "允许几人抢单", example = "允许几人抢单")
    private Integer repertory;

    private String insurance;

    private String doing;

    private String waiting;

    private String userPort;

    private String flyerPort;

    private String orderStatus;

    private Integer publish;
    @IsNullConvertZero
    private BigDecimal preemptTotalAmount;
    @IsNullConvertZero
    private BigDecimal orderAmount;

    private Integer serviceFlowId;

    @ApiModelProperty(value = "修格后的任务佣金")
    @IsNullConvertZero
    private BigDecimal updateOrderAmount;

    @ApiModelProperty(value = "原因")
    private String reason;

    @ApiModelProperty(value = "原因url")
    private String url;

    @ApiModelProperty(value = "微信支付订单编号")
    private String wechatPayOrderNumber;


    @ApiModelProperty(value = "发布者支付任务佣金 佣金金额")
    @IsNullConvertZero
    private BigDecimal cashAmount;

    @IsNullConvertZero
    private BigDecimal weChat;

    @IsNullConvertZero
    private BigDecimal salaryAmount;
    @ApiModelProperty(value = "抢单飞手用户id ")
    private Integer pilotCertificationUserId;
    @ApiModelProperty(value = "抢单飞手用户openid ")
    private String flyerOpenid;

    @ApiModelProperty(value = "飞手获得任务佣金")
    @IsNullConvertZero
    private BigDecimal receiveSalaryAmount;

    @ApiModelProperty(value = "地区编码", example = "307013")
    private String adcode;
    @ApiModelProperty(value = "抢单级别金额")
    @IsNullConvertZero
    private BigDecimal orderLevelAmount;

    @IsNullConvertZero
    private BigDecimal levelCashAmount;
    @IsNullConvertZero
    private BigDecimal levelWeChatAmount;
    @IsNullConvertZero
    private BigDecimal levelSalaryAmount;

    public RequirementsInfoVO buildRequirementsInfoVO() {
        return RequirementsInfoVO.builder().id(this.id).requirementTypeId(this.requirementTypeId).userAccountId(this.userAccountId).publishName(this.publishName)
                .publishPhone(this.publishPhone).requireDescription(this.requireDescription).solved(this.solved).taskStartTime(this.taskStartTime).taskEndTime(this.taskEndTime)
                .taskTitle(this.taskTitle)
                .taskAddress(this.taskAddress)
                .longitude(this.longitude)
                .latitude(this.latitude)
                .requirementTypeName(this.requirementTypeName)
                .publisherNumber(this.publisherNumber)
                .requireUrl(this.requireUrl)
                .orderLevelEnum(this.orderLevel)
                .serviceId(this.serviceId)
                .serviceName(this.serviceName)
                .totalAmount(this.totalAmount)
                .insurance(this.insurance)
                .doing(this.doing)
                .waiting(this.waiting)
                .userPort(this.userPort)
                .flyerPort(this.flyerPort)
                .orderStatus(this.orderStatus)
                .publish(this.publish)
                .preemptTotalAmount(this.preemptTotalAmount)
                .orderAmount(this.orderAmount)
                .updateOrderAmount(this.updateOrderAmount)
                .reason(this.reason)
                .url(this.url)
                .build();

    }

    public RequirementsInfoDO(RequirementsInfoVO requirementsInfoVO) {
        this.id = requirementsInfoVO.getId();
        this.requirementTypeId = requirementsInfoVO.getRequirementTypeId();
        this.userAccountId = requirementsInfoVO.getUserAccountId();
        this.publishName = requirementsInfoVO.getPublishName();
        this.publishPhone = requirementsInfoVO.getPublishPhone();
        this.requireDescription = requirementsInfoVO.getRequireDescription();
        this.provinceCode = requirementsInfoVO.getProvinceCode();
        this.cityCode = requirementsInfoVO.getCityCode();
        this.districtCode = requirementsInfoVO.getDistrictCode();
        this.taskStartTime = requirementsInfoVO.getTaskStartTime();
        this.taskEndTime = requirementsInfoVO.getTaskEndTime();
        this.taskTitle = requirementsInfoVO.getTaskTitle();
        this.taskAddress = requirementsInfoVO.getTaskAddress();
        this.longitude = requirementsInfoVO.getLongitude();
        this.latitude = requirementsInfoVO.getLatitude();
        this.requireUrl = requirementsInfoVO.getRequireUrl();
    }

    public RequirementsInfoDO(ServiceRequirementsEditVO requirementsEditVO) {
        this.id = requirementsEditVO.getRequirementsInfoId();
        this.taskEndTime = requirementsEditVO.getTaskEndTime();
        this.taskStartTime = requirementsEditVO.getTaskStartTime();
        this.serviceId = requirementsEditVO.getServiceId();
        this.requireDescription = requirementsEditVO.getRequireDescription();
        this.taskAddress = requirementsEditVO.getTaskAddress();
        this.longitude = requirementsEditVO.getLongitude();
        this.latitude = requirementsEditVO.getLatitude();
        this.adcode = requirementsEditVO.getAdcode();
        this.orderAmount = requirementsEditVO.getOrderAmount();
    }


}
