package com.mmc.csf.release.entity.module;

import com.mmc.csf.infomation.dto.ModuleInfoDTO;
import com.mmc.csf.release.flyer.vo.ModuleInfoVO;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * @Author small
 * @Date 2023/5/23 14:15
 * @Version 1.0
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class ModuleInfoDO implements Serializable {
    private static final long serialVersionUID = 6637973426087317593L;
    private Integer id;
    /**
     * 模块名称
     */
    private String moduleName;
    /**
     * 模块类型(0云享飞，1飞手，2云仓)
     */
    private Integer moduleType;
    /**
     * 模块代码
     */
    private String moduleCode;
    /**
     * 备注
     */
    private String remark;
    private Integer deleted;
    private Date createTime;
    private Date updateTime;

    public ModuleInfoDTO buildModuleInfoDTO(){
        return ModuleInfoDTO.builder().id(this.id).moduleName(this.moduleName).moduleType(this.moduleType).remark(this.remark)
                .moduleCode(this.moduleCode).deleted(this.deleted).createTime(this.createTime).build();
    }

    public ModuleInfoDO(ModuleInfoVO moduleInfoVO){
        this.id = moduleInfoVO.getId();
        this.moduleCode = moduleInfoVO.getModuleCode();
        this.moduleName = moduleInfoVO.getModuleName();
        this.moduleType = moduleInfoVO.getModuleType();
        this.remark = moduleInfoVO.getRemark();
    }
}
