package com.mmc.csf.release.service;

import com.mmc.csf.common.util.web.ResultBody;
import com.mmc.csf.infomation.qo.IndustryCaseQO;
import com.mmc.csf.infomation.vo.TenderApplyVO;
import com.mmc.csf.infomation.vo.TenderNewsVO;
import org.springframework.web.multipart.MultipartFile;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.Date;

/**
 * author:zhenjie
 * Date:2022/5/21
 * time:17:11
 */
public interface TenderService {
    ResultBody addTenderNews(MultipartFile file, TenderNewsVO tenderNewsVO) throws IOException;

    ResultBody listTenderNews(Integer pageNo, Integer pageSize, String tenderName, Date startTime, Date endTime, Integer using);

    ResultBody updateTenderNews(MultipartFile file, TenderNewsVO tenderNewsVO) throws IOException;

    ResultBody removeTenderNews(Integer id);

    ResultBody listTenderInfo(Integer pageNo, Integer pageSize, Integer tenderNewsId);

    ResultBody updateTenderInfo(Integer id, String tenderContent, BigDecimal tenderPrice);

    ResultBody addTenderApply(TenderApplyVO tenderApplyVO);

    ResultBody listTenderApply(Integer pageNo, Integer pageSize, Integer tenderNewsId, Integer tenderInfoId, String keyword);

    ResultBody listTenderInfoApp(Integer pageNo, Integer pageSize, Integer tenderNewsId, Integer userAccountId);

    ResultBody listTenderInfoAppLatest(Integer pageNo, Integer pageSize, Integer userAccountId);

    ResultBody listNewTenderInfo(IndustryCaseQO industryCaseQO, Integer userAccountId);
}
