package com.mmc.iuav.user.entity.dronepilot;

/**
 * @Author small
 * @Date 2023/7/28 10:43
 * @Version 1.0
 */
public enum CertificationMessage {

    COMMITTED(0, "已提交电子执照认证。"),
    ALREADY_PASSED(1, "电子执照认证已通过。"),
    NOT_PASS(2, "电子执照认证不通过。");
    private int code;
    private String message;

    private CertificationMessage(int code, String message) {
        this.code = code;
        this.message = message;
    }

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public static CertificationMessage match(int key) {

        CertificationMessage result = null;

        for (CertificationMessage s : values()) {
            if (s.getCode() == key) {
                result = s;
                break;
            }
        }

        return result;
    }

    public static CertificationMessage catchMessage(String msg) {

        CertificationMessage result = null;

        for (CertificationMessage s : values()) {
            if (s.getMessage().equals(msg)) {
                result = s;
                break;
            }
        }

        return result;
    }


}
