package com.mmc.iuav.user.entity;

import com.mmc.iuav.user.model.vo.UserTagVO;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * @author: zj
 * @Date: 2023/5/26 20:55
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class UserTagDO implements Serializable {
    private static final long serialVersionUID = -5355286947297870886L;
    private Integer id;
    private Integer cooperationTagId;
    private Integer userAccountId;
    private Integer deleted;
    private Date createTime;
    private Date updateTime;

    public UserTagDO(UserTagVO userTagVO) {
        this.id = userTagVO.getId();
        this.userAccountId = userTagVO.getUserAccountId();
        this.cooperationTagId = userTagVO.getCooperationTagId();
    }

    public UserTagVO buildUserTagVO() {
        return UserTagVO.builder().id(this.id).cooperationTagId(this.cooperationTagId).userAccountId(this.userAccountId).build();
    }

}
