package com.mmc.iuav.page;


import com.mmc.iuav.group.Freeze;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.domain.Page;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;


@Data
@NoArgsConstructor
@AllArgsConstructor
public class BaseInfoQO {

    @ApiModelProperty(value = "开始时间")
    private String startTime;

    @ApiModelProperty(value = "结束时间")
    private String endTime;

    @ApiModelProperty(value = "页码")
    @NotNull(message = "页码不能为空", groups = { Page.class, Freeze.class })
    @Min(value = 1, groups = Page.class,message = "pageNo不能少于1")
    private Integer pageNo;

    @ApiModelProperty(value = "每页显示数")
    @NotNull(message = "每页显示数不能为空", groups = { Page.class, Freeze.class })
    @Min(value = 1, groups = Page.class,message = "pageSize不能少于1")
    private Integer pageSize;

    /**
     * 初始化起始查询行并返回当前页
     */
    public Integer buildCurrentPage() {
        Integer pageNo = this.pageNo;
        this.pageNo = (pageNo - 1) * pageSize;
        return pageNo;
    }
}
