package com.mmc.iuav.user.model.vo;

import com.mmc.iuav.group.Create;
import com.mmc.iuav.group.Update;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author: zj
 * @Date: 2023/7/27 14:49
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(description = "新增/修改参数类")
public class RealNameAuthVO implements Serializable {
    private static final long serialVersionUID = -8096210744248682679L;
    @ApiModelProperty(value = "用户ID")
    @NotNull(message = "用户ID不能为空", groups = {Update.class, Create.class})
    private Integer userAccountId;

    @ApiModelProperty(value = "名字")
    @NotBlank(message = "名字不能为空", groups = {Create.class})
    private String userName;

    @ApiModelProperty(value = "身份证号码")
    @NotBlank(message = "身份证号码不能为空", groups = {Create.class})
    private String idNumber;

    @ApiModelProperty(value = "身份证正面照片地址")
    @NotBlank(message = "身份证正面照片不能为空", groups = {Create.class})
    private String frontIdImg;

    @ApiModelProperty(value = "身份证反面照片地址")
    @NotBlank(message = "身份证反面照片不能为空", groups = {Create.class})
    private String backIdImg;

    @ApiModelProperty(value = "unionId")
    private String unionId;

}
