package com.mmc.iuav.user.model.qo.userpoints;

import com.mmc.iuav.group.Freeze;
import com.mmc.iuav.group.Page;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

/**
 * @Author small
 * @Date 2023/8/7 13:45
 * @Version 1.0
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class UserPointsDetailsQO {
    @ApiModelProperty(value = "当前页", required = true, example = "1")
    @NotNull(message = "当前页不能为空", groups = {Page.class, Freeze.class})
    @Min(value = 1, groups = Page.class)
    private Integer pageNo;

    @ApiModelProperty(value = "页大小", required = true, example = "10")
    @NotNull(message = "页大小不能为空", groups = {Page.class, Freeze.class})
    @Min(value = 1, groups = Page.class)
    private Integer pageSize;


    @ApiModelProperty(value = "用户id", example = "26", required = true)
    private Integer userAccountId;


    public void buildCurrentPage() {
        this.pageNo = (pageNo - 1) * pageSize;
    }
}
