package com.mmc.iuav.user.model.fdd.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * (ContractInfoDO)实体类
 *
 * @author makejava
 * @since 2023-09-07 10:14:08
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class ContractInfoDTO implements Serializable {
    private static final long serialVersionUID = -42558889792167148L;
    @ApiModelProperty(value = "id")
    private Integer id;

    @ApiModelProperty(value = "发起合同方用户唯一标识")
    private String unionId;

    @ApiModelProperty(value = "订单号")
    private String orderNo;

    @ApiModelProperty(value = "合同编号")
    private String contractNo;

    @ApiModelProperty(value = "合同标题")
    private String contractTitle;

    @ApiModelProperty(value = "状态： 0、等待平台签署1、平台签署失败 2、等待（买家/供应商）签署（平台签署成功） 3、（买家/供应商）签署失败 4、（买家/供应商）签署成功、5、归档")
    private Integer signStatus;

    @ApiModelProperty(value = "签署完成日期")
    private Date singerTime;

    @ApiModelProperty(value = "平台签署失败备注信息")
    private String aRemark;

    @ApiModelProperty(value = "（买家/供应商）签署失败备注信息")
    private String bRemark;

    @ApiModelProperty(value = "平台签署交易号")
    private String aTransactionId;

    @ApiModelProperty(value = "（买家/供应商）签署交易号")
    private String bTransactionId;

    @ApiModelProperty(value = "创建时间")
    private Date createTime;

    @ApiModelProperty(value = "更新时间")
    private Date updateTime;

    @ApiModelProperty(value = "归档日期")
    private Date archiveDate;
}

