package com.mmc.iuav.user.enums;

/**
 * @Author LW
 * @date 2023/8/19 18:53
 * 概要：
 */
public enum PayMethodEnums {
    PUBLISH_ORDER(100, "订单发布"),
    CANCEL_ORDER_TAKING(200, "未接单时取消订单"),
    RECEIVED_ORDER_CANCEL(300, "已接单取消订单"),
    FLYING_ORDER_TAKING(400, "飞手抢单"),
    CUSTOMER_SERVICE_CANCEL_ORDER(500, "客服判定飞手无责取消订单"),
    FLYER_CANCEL_ORDER(600, "飞手有责取消订单"),
    NORMAL_SETTLEMENT(700, "正常结算"),
    MODIFY_THE_ORDER(800, "修改订单金额状态（大于）"),
    FLYING_HAND_NOT_CONFIRMED_GT(900, "飞手未确认修改金额大于原订单状态"),
    FLYING_HAND_CONFIRM_LT(1000, "飞手确认修改金额小于原订单状态"),
    USER_TOP_UP(1100, "充值"),
    PAY_UAV_ORDER_REFUND(1400, "商城订单退款"),
    ORDER_INCOME(1500, "订单收益"),
    GIVE_BACK_PLEDGE(1600, "租赁押金退回");

    PayMethodEnums(Integer code, String method) {
        this.code = code;
        this.method = method;
    }

    private Integer code;

    private String method;

    public Integer getCode() {
        return this.code;
    }

    public String getMethod() {
        return this.method;
    }
}
