package com.mmc.iuav.user.model.vo.wallet;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @Author LW
 * @date 2023/9/7 16:07
 * 概要：
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class PayUavWalletVO implements Serializable {

    private static final long serialVersionUID = 1683979749411588941L;

    @ApiModelProperty(value = "用户ID", required = true)
    private Integer userAccountId;

    @ApiModelProperty(value = "云享金")
    private BigDecimal cashAmount;

    @ApiModelProperty(value = "佣金")
    private BigDecimal salaryAmount;

    @ApiModelProperty(value = "订单状态 100：订单支付  1400:商城订单退款 1500:订单提成 999:确认收货 1600：租赁押金退回", required = true)
    private Integer orderStatus;

    @ApiModelProperty(value = "订单备注")
    private String remark;
}
