package com.mmc.iuav.user.controller;

import com.mmc.iuav.group.Insert;
import com.mmc.iuav.group.Update;
import com.mmc.iuav.response.ResultBody;
import com.mmc.iuav.user.model.qo.ApplyQO;
import com.mmc.iuav.user.model.vo.CooperationTagVO;
import com.mmc.iuav.user.model.vo.UserApplyTagDetailsVO;
import com.mmc.iuav.user.model.vo.UserApplyTagVO;
import com.mmc.iuav.user.model.vo.UserCooperationTagVO;
import com.mmc.iuav.user.service.CooperationService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * @author: zj @Date: 2023/5/17 21:17
 */
@Api(tags = "合作加盟")
@RequestMapping("/cooperation/")
@RestController
public class CooperationController extends BaseController {
  @Autowired private CooperationService cooperationService;

  @ApiOperation(value = "加盟标签列表")
  @ApiResponses({@ApiResponse(code = 200, message = "OK", response = CooperationTagVO.class)})
  @GetMapping("listTag")
  public ResultBody listTag() {
    return ResultBody.success(cooperationService.listTag());
  }

  @ApiOperation(value = "根据id获取标签信息")
  @ApiResponses({@ApiResponse(code = 200, message = "OK", response = CooperationTagVO.class)})
  @GetMapping("getTagById")
  public ResultBody getTagById(@RequestParam("id") Integer id) {
    return cooperationService.getTagById(id);
  }

  @ApiOperation(value = "申请加盟")
  @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
  @PostMapping("apply")
  public ResultBody apply(
      @Validated(value = {Insert.class}) @RequestBody UserApplyTagVO userApplyTagVO,
      HttpServletRequest request) {
    Integer userAccountId = this.getUserLoginInfoFromRedis(request).getUserAccountId();
    userApplyTagVO.setUserAccountId(userAccountId);
    return cooperationService.apply(userApplyTagVO);
  }

  @ApiOperation(value = "后台-申请列表")
  @ApiResponses({@ApiResponse(code = 200, message = "OK", response = UserApplyTagVO.class)})
  @PostMapping("listUserApplyTag")
  public ResultBody<UserApplyTagVO> listUserApplyTag(@RequestBody ApplyQO applyQO) {
    return ResultBody.success(cooperationService.listUserApplyTag(applyQO));
  }

  @ApiOperation(value = "强制删除")
  @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
  @GetMapping("deleteApplyTag")
  public ResultBody deleteApplyTag(Integer id) {
    return ResultBody.success(cooperationService.deleteApplyTag(id));
  }

  @ApiOperation(value = "审批详情")
  @ApiResponses({@ApiResponse(code = 200, message = "OK", response = UserApplyTagDetailsVO.class)})
  @GetMapping("applyTagDetails")
  public ResultBody applyTagDetails(
      @RequestParam(value = "id") Integer id,
      @RequestParam(value = "userAccountId") Integer userAccountId) {
    return cooperationService.applyTagDetails(id, userAccountId);
  }

  @ApiOperation(value = "审批")
  @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
  @GetMapping("approvalApplyTag")
  public ResultBody approvalApplyTag(
      @RequestParam(value = "id") Integer id, @RequestParam(value = "status") Boolean status) {
    return ResultBody.success(cooperationService.approvalApplyTag(id, status));
  }

  @ApiOperation(value = "后台设置小程序用户标签")
  @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
  @PostMapping("changeUserTag")
  public ResultBody changeUserTag(
      @Validated(Update.class) @RequestBody UserCooperationTagVO userCooperationTagVO) {
    return cooperationService.changeUserTag(userCooperationTagVO);
  }

  @ApiOperation(value = "获取合作渠道标签", hidden = true)
  @ApiResponses({@ApiResponse(code = 200, message = "OK", response = CooperationTagVO.class)})
  @GetMapping("feignListCooperationTag")
  public List<CooperationTagVO> feignListCooperationTag() {
    return cooperationService.listTag();
  }
}
