package com.mmc.iuav.user.model.vo;

import com.mmc.iuav.group.Insert;
import com.mmc.iuav.group.Update;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author: zj
 * @Date: 2023/5/16 13:56
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "com.mmc.iuav.user.model.vo.WxLoginVO", description = "登录参数")
public class WxLoginVO implements Serializable {
    private static final long serialVersionUID = 2500957724470423989L;
    @ApiModelProperty(value = "请求code")
    @NotNull(message = "code不能为空", groups = {Insert.class})
    private String code;
    @ApiModelProperty(value = "登录来源, 0小程序登录， 1pc登录", example = "0", allowableValues = "0,1")
    @NotNull(message = "登录来源不能为空", groups = {Insert.class})
    private Integer fromPort;
    @ApiModelProperty(value = "用户来源：0自然流，1海报，2抖音，3公众号，4社群，5招投标，默认0", example = "0", required = true)
    private Integer source;
}
