package com.mmc.iuav.user.controller;

import com.mmc.iuav.group.Insert;
import com.mmc.iuav.response.ResultBody;
import com.mmc.iuav.user.model.qo.LoginUserQO;
import com.mmc.iuav.user.model.vo.AppUserSucVO;
import com.mmc.iuav.user.model.vo.WxLoginVO;
import com.mmc.iuav.user.service.AuthService;
import io.swagger.annotations.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;

/**
 * @author: zj
 * @Date: 2023/5/15 15:50
 */
@Api(tags = "登录授权")
@RequestMapping("/auth/")
@RestController
public class AuthController {

    @Autowired
    private AuthService authService;

    @ApiOperation(value = "小程序登录/注册")
    @ApiResponses({ @ApiResponse(code = 200, message = "OK", response = AppUserSucVO.class) })
    @PostMapping("appletLogin")
    public ResultBody appletLogin(@Validated(value = {Insert.class})@RequestBody WxLoginVO wxLoginVO){
        return authService.appletLogin(wxLoginVO);
    }

    @ApiOperation(value = "平台账号密码登录")
    @ApiResponses({ @ApiResponse(code = 200, message = "OK", response = ResultBody.class) })
    @PostMapping("backEndLogin")
    public ResultBody backEndLogin(
            @ApiParam(value = "账号登录QO", required = true) @Validated @RequestBody LoginUserQO param) {
        return authService.backEndLogin(param);
    }

    @ApiOperation(value = "测试-小程序unionId登录/注册")
    @ApiResponses({ @ApiResponse(code = 200, message = "OK", response = AppUserSucVO.class) })
    @PostMapping("testAppletLogin")
    public ResultBody testAppletLogin(@RequestParam String unionId){
        return authService.testAppletLogin(unionId);
    }
}
