package com.mmc.iuav.page;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/** 
* @author 作者 geDuo
* @version 创建时间：2021年11月10日 上午11:40:34 
* @explain 类说明 
*/
@Data
@AllArgsConstructor
@NoArgsConstructor
public class TimePage implements Serializable {
	private static final long serialVersionUID = -2530498038870578257L;
	private int pageNo;// 分页起始页
	private int pageSize;// 每页记录数
	private long totalCount;// 总记录条数
	private long totalPage;// 总页数
	private long ctime;

	public static TimePage buildPage(int pageNo, int pageSize, int totalCount, long ctime) {
		TimePage page = new TimePage();
		page.pageNo = pageNo;
		page.pageSize = pageSize;
		page.totalCount = totalCount;
		page.totalPage = (totalCount % pageSize == 0) ? (totalCount / pageSize) : (totalCount / pageSize + 1);
		page.setCtime(ctime);
		return page;
	}
}
