package com.mmc.iuav.user.controller.wallet;

import com.mmc.iuav.response.ResultBody;
import com.mmc.iuav.user.controller.BaseController;
import com.mmc.iuav.user.model.dto.wallet.WithdrawalApplyDTO;
import com.mmc.iuav.user.model.qo.wallet.WalletFlowQO;
import com.mmc.iuav.user.model.qo.wallet.WithdrawalApplyQO;
import com.mmc.iuav.user.model.vo.wallet.ApplyWithdrawalVO;
import com.mmc.iuav.user.service.xzsz.WithdrawalService;
import io.swagger.annotations.*;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;

/**
 * @author: zj
 * @Date: 2023/8/23 15:58
 */
@Slf4j
@Api(tags = "提现相关")
@RequestMapping("/withdrawal/")
@RestController
public class WithdrawalController extends BaseController {

    @Autowired
    private WithdrawalService withdrawalService;

    @ApiOperation(value = "提现申请")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("apply")
    public ResultBody apply(@RequestBody ApplyWithdrawalVO applyWithdrawalVO, HttpServletRequest request) {
        return withdrawalService.apply(applyWithdrawalVO, this.getUserLoginInfoFromRedis(request).getUserAccountId());
    }

    @ApiOperation(value = "个人提现明细列表")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("withdrawalList")
    public ResultBody withdrawalList(HttpServletRequest request, @RequestBody WalletFlowQO walletFlowQO) {
        return withdrawalService.withdrawalList(this.getUserLoginInfoFromRedis(request).getUserAccountId(), walletFlowQO);
    }

    @ApiOperation(value = "PC端-提现管理-分页查询")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = WithdrawalApplyDTO.class)})
    @PostMapping("listPageWithdrawalApply")
    public ResultBody listPageWithdrawalApply(
            @ApiParam(value = "提现管理查询QO", required = true) @RequestBody WithdrawalApplyQO param) {
        return ResultBody.success(withdrawalService.listPageWithdrawalApply(param));
    }

    @ApiOperation(value = "PC端-提现管理-审批")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("approveWithdrawalApply")
    public ResultBody approveWithdrawalApply(@ApiParam(value = "申请单ID", required = true) @RequestParam Integer id,
                                             @ApiParam(value = "状态: 0提现申请中 1审批通过 2审批未通过", required = true) @RequestParam Integer applyStatus,
                                             @ApiParam(value = "备注") String remark,
                                             HttpServletRequest request) {
        return ResultBody.success(withdrawalService.approveWithdrawalApply(id, applyStatus, this.getUserLoginInfoFromRedis(request).getUserAccountId(), remark));
    }
}
