package com.mmc.iuav.user.entity;

import com.mmc.iuav.user.model.vo.UserApplyTagVO;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @author: zj
 * @Date: 2023/5/17 21:59
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class UserApplyTagDO implements Serializable {
    private static final long serialVersionUID = -7581203992821286124L;
    private Integer id;
    private Integer cooperationTagId;
    private Integer userAccountId;
    private String applyName;
    private String applyPhone;
    private String remark;

    public UserApplyTagVO buildUserApplyTagVO(){
        return UserApplyTagVO.builder().id(id).cooperationTagId(cooperationTagId).userAccountId(this.userAccountId)
                .applyName(this.applyName).applyPhone(this.applyPhone).remark(this.remark).build();
    }

    public UserApplyTagDO(UserApplyTagVO userApplyTagVO){
        this.cooperationTagId = userApplyTagVO.getCooperationTagId();
        this.userAccountId = userApplyTagVO.getUserAccountId();
        this.applyName = userApplyTagVO.getApplyName();
        this.applyPhone = userApplyTagVO.getApplyPhone();
        this.remark = userApplyTagVO.getRemark();
    }

}
