package com.mmc.iuav.user.service;

import com.mmc.iuav.response.ResultBody;
import com.mmc.iuav.user.entity.CompanyBackUserDO;
import com.mmc.iuav.user.entity.CompanyInfoDO;
import com.mmc.iuav.user.model.dto.LoginSuccessDTO;
import com.mmc.iuav.user.model.qo.CompanyInfoQO;
import com.mmc.iuav.user.model.vo.CompanyInfoVO;

import java.util.List;

/**
 * @author: zj
 * @Date: 2023/7/3 15:39
 */
public interface CompanyService {
    /**
     * 新增
     *
     * @param companyInfo
     * @return
     */
    ResultBody addCompanyInfo(CompanyInfoVO companyInfo);

    /**
     * 移除
     *
     * @param id
     * @param token
     * @return
     */
    ResultBody removeCompanyInfo(Integer id, String token);

    /**
     * 修改
     *
     * @param companyInfo
     * @return
     */
    ResultBody updateCompanyInfo(CompanyInfoVO companyInfo);

    /**
     * 单位查询
     *
     * @param id
     * @return
     */
    ResultBody<CompanyInfoVO> getCompanyInfoById(Integer id);

    /**
     * 单位列表
     *
     * @param companyInfoQO
     * @param userLoginInfoFromRedis
     * @return
     */
    ResultBody<CompanyInfoVO> listCompanyPage(CompanyInfoQO companyInfoQO, LoginSuccessDTO userLoginInfoFromRedis);

    /**
     * 通过用户id获取单位信息
     *
     * @param backUserAccountId
     * @return
     */
    CompanyInfoVO getCompanyInfoByBackUserAccountId(Integer backUserAccountId);

    /**
     * 添加绑定关系
     *
     * @param companyBackUserDO
     */
    void addCompanyBackUser(CompanyBackUserDO companyBackUserDO);

    /**
     * 修改绑定关系
     *
     * @param companyBackUserDO
     */
    void updateCompanyBackUser(CompanyBackUserDO companyBackUserDO);

    List<CompanyInfoVO> listCompanyPageBack(CompanyInfoQO companyInfoQO);

    /**
     * 通过用户id获取单位信息
     *
     * @param backUserIds
     * @return
     */
    List<CompanyInfoDO> listCompanyInfoByUID(List<Integer> backUserIds);

    /**
     * 绑定小程序用户
     *
     * @param userLoginInfoFromRedis
     * @param userAccountId
     * @param companyInfoId
     * @return
     */
    ResultBody bindingCompanyMember(LoginSuccessDTO userLoginInfoFromRedis, Integer userAccountId, Integer companyInfoId);

    /**
     * 获取小程序用户绑定企业信息
     *
     * @param userAccountId
     * @return
     */
    CompanyInfoVO getAppCompanyInfoUId(Integer userAccountId);

    /**
     * 获取公司绑定后台用户
     *
     * @param id
     * @return
     */
    CompanyBackUserDO getCompanyBackUserByCompanyId(Integer id);

    /**
     * 解绑成员
     *
     * @param userLoginInfoFromRedis
     * @param userAccountId
     * @param companyInfoId
     * @return
     */
    ResultBody unbindCompanyMember(LoginSuccessDTO userLoginInfoFromRedis, Integer userAccountId, Integer companyInfoId);

    /**
     * 转交管理员
     *
     * @param userLoginInfoFromRedis
     * @param fromUserAccountId
     * @param toUserAccountId
     * @param companyInfoId
     * @return
     */
    ResultBody transferLeader(LoginSuccessDTO userLoginInfoFromRedis, Integer fromUserAccountId, Integer toUserAccountId, Integer companyInfoId);

    /**
     * 成员列表
     *
     * @param companyInfoId
     * @param userLoginInfoFromRedis
     * @param pageNo
     * @param pageSize
     * @return
     */
    ResultBody listCompanyMembers(Integer companyInfoId, LoginSuccessDTO userLoginInfoFromRedis, Integer pageNo, Integer pageSize);

    ResultBody<CompanyInfoVO> getCompanyInfoByBUId(Integer backUserAccountId);

    /**
     * 查看绑定的后台账号个数
     *
     * @param id
     * @return
     */
    Integer countCompanyBackUser(Integer id);

    /**
     * 解绑当前单位全部成员
     *
     * @param id
     */
    void unbindingAllUsers(Integer id);

    List<CompanyInfoVO> listCompanyInfoByIds(List<Integer> ids);
}
