package com.mmc.iuav.user.auth;

import com.alibaba.fastjson2.JSONObject;
import com.mmc.iuav.auth.JwtConstant;
import com.mmc.iuav.auth.JwtUtil;
import com.mmc.iuav.user.dao.RoleDao;
import com.mmc.iuav.user.entity.RoleInfoDO;
import com.mmc.iuav.user.enums.UserTypeEnums;
import com.mmc.iuav.user.model.dto.LoginSuccessDTO;
import com.mmc.iuav.user.model.vo.AppUserSucVO;
import com.mmc.iuav.user.model.vo.BackUserAccountVO;
import com.mmc.iuav.user.model.vo.CompanyInfoVO;
import com.mmc.iuav.user.model.vo.UserAccountVO;
import com.mmc.iuav.user.service.CompanyService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

/**
 * @author: zj
 * @Date: 2023/8/14 16:48
 */
@Component
public class AuthHandler {

    @Autowired
    private RoleDao roleDao;
    
    @Autowired
    private CompanyService companyService;

    @Autowired
    private StringRedisTemplate stringRedisTemplate;

    public AppUserSucVO addAppLoginCache(UserAccountVO userAccountVO) {
        Map<String, Object> map = new HashMap<String, Object>();
        map.put(JwtConstant.USER_ACCOUNT_ID, userAccountVO.getId());
        map.put(JwtConstant.TOKEN_TYPE, JwtConstant.IUAV_TOKEN);
        String token = JwtUtil.createJwt(map);
        LoginSuccessDTO loginSuccessDTO = LoginSuccessDTO.builder().token(token).userAccountId(userAccountVO.getId()).uid(userAccountVO.getId() + "")
                .userName(userAccountVO.getUserName()).nickName(userAccountVO.getNickName()).phoneNum(userAccountVO.getPhoneNum()).portType(UserTypeEnums.APP.getType()).build();
        stringRedisTemplate.opsForValue().set(
                token, JSONObject.toJSONString(loginSuccessDTO),
                JwtConstant.EXPIRATION, TimeUnit.MILLISECONDS);

        AppUserSucVO appUserSucVO = AppUserSucVO.builder().token(token).uid(userAccountVO.getUid()).phoneNum(userAccountVO.getPhoneNum())
                .nickName(userAccountVO.getNickName()).userAccountId(userAccountVO.getId()).portType(UserTypeEnums.APP.getType()).build();
        return appUserSucVO;
    }

    public LoginSuccessDTO addPcLoginCache(BackUserAccountVO user) {
        // 查询单位信息
        CompanyInfoVO companyInfoVO = companyService.getCompanyInfoByBackUserAccountId(user.getId());
        companyInfoVO.setLeader(1);
        // 角色信息
        RoleInfoDO roleInfoDO = roleDao.getRoleInfoByUserId(user.getId());
        Map<String, Object> map = new HashMap<String, Object>();
        map.put(JwtConstant.USER_ACCOUNT_ID, user.getId());
        map.put(JwtConstant.TOKEN_TYPE, JwtConstant.M_TOKEN);
        String token = JwtUtil.createJwt(map);
        LoginSuccessDTO loginSuccessDTO = LoginSuccessDTO.builder().token(token).userAccountId(user.getId()).accountNo(user.getAccountNo()).uid(user.getId() + "")
                .userName(user.getUserName()).nickName(user.getUserName()).phoneNum(user.getPhoneNum()).portType(UserTypeEnums.PC.getType())
                .companyInfoVO(companyInfoVO == null ? null : companyInfoVO)
                .roleInfo(roleInfoDO.buildRoleInfoDTO()).build();
        stringRedisTemplate.opsForValue().set(
                token, JSONObject.toJSONString(loginSuccessDTO),
                JwtConstant.EXPIRATION, TimeUnit.MILLISECONDS);
        loginSuccessDTO.setToken(token);
        return loginSuccessDTO;
    }
}
