package com.mmc.iuav.user.entity.fdd;

import com.mmc.iuav.user.model.fdd.dto.SealInfoDTO;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * (SealInfoDO)实体类
 *
 * @author makejava
 * @since 2023-09-08 14:30:13
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class SealInfoDO implements Serializable {
    private static final long serialVersionUID = -88451609760389058L;

    private Integer id;
    /**
     * 印章名称
     */
    private String sealName;
    /**
     * 印章编号
     */
    private String signatureId;
    /**
     * 用户唯一标识
     */
    private String unionId;
    /**
     * 印章状态：0未使用 1使用中
     */
    private Integer sealStatus;
    /**
     * 印章图片
     */
    private String sealUrl;

    private Date createTime;

    private Date updateTime;

    public SealInfoDTO buildSealInfoDTO() {
        return SealInfoDTO.builder().id(this.id).sealStatus(this.sealStatus).sealName(this.sealName)
                .signatureId(this.signatureId).createTime(this.createTime).sealUrl(this.sealUrl).build();
    }
}

