package com.mmc.iuav.user.model.qo.dronepilot;

import com.mmc.iuav.group.Freeze;
import com.mmc.iuav.group.Page;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @Author small
 * @Date 2023/7/29 17:15
 * @Version 1.0
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class PilotCertificationLogQO implements Serializable {

    @ApiModelProperty(value = "账号筛选（uid,姓名，手机号）", required = false, example = "张三")
    private String accountNumber;

    @ApiModelProperty(value = "当前页", required = true, example = "1")
    @NotNull(message = "当前页不能为空", groups = {Page.class, Freeze.class})
    @Min(value = 1, groups = Page.class)
    private Integer pageNo;

    @ApiModelProperty(value = "页大小", required = true, example = "10")
    @NotNull(message = "页大小不能为空", groups = {Page.class, Freeze.class})
    @Min(value = 1, groups = Page.class)
    private Integer pageSize;

    public void buildCurrentPage() {
        this.pageNo = (pageNo - 1) * pageSize;
    }
}
