package com.mmc.iuav.user.model.qo.dronepilot;

import com.mmc.iuav.group.Freeze;
import com.mmc.iuav.group.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author 张培
 */

@Data
@AllArgsConstructor
@NoArgsConstructor
public class PilotTeamQO implements Serializable {

    @ApiModelProperty(value = "飞手是否同意 0未操作 1飞手同意加入 2飞手拒绝", required = false, example = "0")
    private Integer pilotStatus;

    @ApiModelProperty(value = "当前页", required = true, example = "1")
    @NotNull(message = "当前页不能为空", groups = {Page.class, Freeze.class})
    @Min(value = 1, groups = Page.class)
    private Integer pageNo;

    @ApiModelProperty(value = "页大小", required = true, example = "10")
    @NotNull(message = "页大小不能为空", groups = {Page.class, Freeze.class})
    @Min(value = 1, groups = Page.class)
    private Integer pageSize;

    @ApiModelProperty(value = "飞手团队后台id")
    private Integer backId;

    public void buildCurrentPage() {
        this.pageNo = (pageNo - 1) * pageSize;
    }
}
