package com.mmc.iuav.user.service.userpoints.impl;

import com.mmc.iuav.page.PageResult;
import com.mmc.iuav.response.ResultBody;
import com.mmc.iuav.user.controller.userpoints.config.UserPointsEnum;
import com.mmc.iuav.user.dao.userpoints.UserPointsDao;
import com.mmc.iuav.user.dao.userpoints.UserPointsDetailsDao;
import com.mmc.iuav.user.entity.userpoints.UserPointsDO;
import com.mmc.iuav.user.entity.userpoints.UserPointsDetails;
import com.mmc.iuav.user.model.dto.userpoints.UserPointsDTO;
import com.mmc.iuav.user.model.dto.userpoints.UserPointsDetailsDTO;
import com.mmc.iuav.user.model.qo.userpoints.AppPointsDetailsQO;
import com.mmc.iuav.user.model.qo.userpoints.UserPointQO;
import com.mmc.iuav.user.model.qo.userpoints.UserPointsDetailsQO;
import com.mmc.iuav.user.model.vo.userpoints.ChangeUserPointVO;
import com.mmc.iuav.user.model.vo.userpoints.PointTypeVO;
import com.mmc.iuav.user.service.userpoints.UserPointsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @Author small
 * @Date 2023/8/5 16:31
 * @Version 1.0
 */
@Service
public class UserPointsServiceImpl implements UserPointsService {

    @Autowired
    private UserPointsDao userPointsDao;

    @Autowired
    private UserPointsDetailsDao userPointsDetailsDao;

    @Override
    public PageResult userPointList(UserPointQO param) {
        int count = userPointsDao.count(param);
        if (count == 0) {
            return PageResult.buildPage(param.getPageNo(), param.getPageSize(), count);
        }
        Integer pageNo = param.getPageNo();
        param.buildCurrentPage();
        List<UserPointsDO> userPointList = userPointsDao.userPointList(param);
        List<UserPointsDTO> collect = userPointList.stream().map(UserPointsDO::buildUserPointsDTO).collect(Collectors.toList());
        return PageResult.buildPage(pageNo, param.getPageSize(), count, collect);

    }

    @Override
    public PageResult detailPoint(UserPointsDetailsQO param) {
        int count = userPointsDetailsDao.detailPointCount(param);
        if (count == 0) {
            return PageResult.buildPage(param.getPageNo(), param.getPageSize(), count);
        }
        Integer pageNo = param.getPageNo();
        param.buildCurrentPage();
        List<UserPointsDetails> userPointsDetails = userPointsDetailsDao.detailPoint(param);
        List<UserPointsDetailsDTO> collect = userPointsDetails.stream().map(UserPointsDetails::buildPoint).collect(Collectors.toList());
        return PageResult.buildPage(pageNo, param.getPageSize(), count, collect);
    }

    @Override
    public PageResult appDetailPoint(Integer userAccountId, AppPointsDetailsQO param) {
        param.setUserAccountId(userAccountId);
        int count = userPointsDetailsDao.appDetailPointCount(param);
        if (count == 0) {
            return PageResult.buildPage(param.getPageNo(), param.getPageSize(), count);
        }
        Integer pageNo = param.getPageNo();
        param.buildCurrentPage();
        List<UserPointsDetails> userPointsDetails = userPointsDetailsDao.appDetailPoint(param);
        List<UserPointsDetailsDTO> collect = userPointsDetails.stream().map(UserPointsDetails::buildPoint).collect(Collectors.toList());
        return PageResult.buildPage(pageNo, param.getPageSize(), count, collect);
    }

    @Transactional
    @Override
    public ResultBody change(ChangeUserPointVO changePoint) {
        UserPointsDO userPointsDO = userPointsDao.selectUserPoints(changePoint.getUserAccountId());
        userPointsDO.setTotalPoints(userPointsDO.getTotalPoints() + changePoint.getChangePoint());
        // 修改用户积分
        userPointsDao.updatePoints(userPointsDO);
        // 添加记录
        UserPointsDetails userPointsDetails = new UserPointsDetails();
        userPointsDetails.setUserAccountId(changePoint.getUserAccountId());
        userPointsDetails.setPoint(changePoint.getChangePoint());
        // 根据不同变动
        userPointsDetails.setPointSource(UserPointsEnum.match(changePoint.getChangeType()).getMessage());
        userPointsDetailsDao.insertPointsDetails(userPointsDetails);
        return ResultBody.success();
    }

    @Override
    public ResultBody listChangeType() {
        List<PointTypeVO> types = new ArrayList<PointTypeVO>();
        for (UserPointsEnum pointsEnum : UserPointsEnum.values()) {
            PointTypeVO pointTypeVO = new PointTypeVO();
            pointTypeVO.setCode(pointsEnum.getCode());
            pointTypeVO.setMessage(pointsEnum.getMessage());
            types.add(pointTypeVO);
        }
        return ResultBody.success(types);
    }
}
