package com.mmc.iuav.user.entity;

import com.mmc.iuav.user.model.vo.AttachmentVO;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * @Author LW
 *
 * @date 2023/6/27 13:56 概要：
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class TagApplyResourceDO implements Serializable {
  private Integer userApplyTagId;
  private String url;
  private Integer type;
  private Date createTime;
  private Date updateTime;

  public TagApplyResourceDO(AttachmentVO d, Integer applyId) {
    this.userApplyTagId = applyId;
    this.type = d.getType();
    this.url = d.getUrl();
  }

  public AttachmentVO buildAttachmentVO() {
    return AttachmentVO.builder().url(url).type(type).build();
  }
}
