package com.mmc.iuav.user.dao;

import com.mmc.iuav.user.entity.UserAccountDO;
import com.mmc.iuav.user.model.qo.BUserAccountQO;
import org.apache.ibatis.annotations.Mapper;

import java.util.List;

/**
 * @author: zj
 * @Date: 2023/5/16 19:26
 */
@Mapper
public interface UserServiceDao {
    /**
     * 根据用户unionId查询用户信息
     * @param unionId
     * @return
     */
    UserAccountDO getUserAccountInfoByUnionId(String unionId);

    /**
     * 插入用户信息
     * @param userAccountDO
     */
    void insertUserAccount(UserAccountDO userAccountDO);

    /**
     * 根据用户id查询用户信息
     * @param userAccountId
     * @return
     */
    UserAccountDO getUserAccountById(Integer userAccountId);

    /**
     * 修改用户信息
     * @param userAccountDO
     */
    void update(UserAccountDO userAccountDO);

    /**
     * 根据用户地区查询后台用户id
     * @param provinceCode
     * @param cityCode
     * @param districtCode
     * @return
     */
    List<Integer> listUserAccountIdsByDistrictCode(Integer provinceCode, Integer cityCode, Integer districtCode);

    /**
     * 登录账号密码查询用户信息
     * @param accountNo
     * @param passWord
     * @return
     */
    UserAccountDO getUserLoginInfo(String accountNo, String passWord);

    /**
     * 批量获取用户信息
     * @param bUserAccountQO
     * @return
     */
    List<UserAccountDO> feignListBAccountPage(BUserAccountQO bUserAccountQO);

    /**
     * 删除用户
     * @param removeNO
     * @param userAccountId
     */
    void removeUserAccount(String removeNO, Integer userAccountId);

    /**
     * 根据账号名称查询数量
     * @param excludeId
     * @param accountNo
     * @return
     */
    int countUserAccountNo(Integer excludeId, String accountNo);

    /**
     * 查询用户数量
     * @param param
     * @return
     */
    int countListBAccountPage(BUserAccountQO param);

    /**
     * 查询用户信息
     * @param param
     * @return
     */
    List<UserAccountDO> listBAccountPage(BUserAccountQO param);

    /**
     * 修改用户密码
     * @param id
     * @param passWord
     */
    void updatePassword(Integer id, String passWord);

    /**
     * 获取用户密码
     * @param id
     * @return
     */
    UserAccountDO getUserAuthPwdInfo(Integer id);
}
