package com.mmc.iuav.user.controller.fdd;

import com.mmc.iuav.response.ResultBody;
import com.mmc.iuav.user.controller.BaseController;
import com.mmc.iuav.user.model.fdd.resp.CompanyVerifyResp;
import com.mmc.iuav.user.model.fdd.resp.PersonVerifyResp;
import com.mmc.iuav.user.service.fdd.UserFddAuthService;
import io.swagger.annotations.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import springfox.documentation.annotations.ApiIgnore;

import javax.servlet.http.HttpServletRequest;
import java.util.Map;

/**
 * @author:zhenjie Date:2022/9/1
 * time:15:44
 */
@Api(tags = {"小程序-fdd用户认证" })
@RestController
@RequestMapping("/fdd/")
public class UserFddAuthController extends BaseController {

    @Autowired
    private UserFddAuthService userFddAuthService;

    @ApiOperation(value = "注册法大大账号")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = String.class)})
    @ApiIgnore
    @GetMapping("register")
    public String register(@ApiParam(value = "唯一标识当类型为1的时候传openid 当为2的时候传id") @RequestParam String uid, @ApiParam(value = "账号类型 1个人 2企业") @RequestParam String accountType) {
        return userFddAuthService.register(uid, accountType);
    }

    @ApiOperation(value = "获取个人实名认证地址")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = PersonVerifyResp.class)})
    @GetMapping("getPersonVerifyUrl")
    public ResultBody getPersonVerifyUrl(HttpServletRequest request) {
        return userFddAuthService.getPersonVerifyUrl(this.getUserLoginInfoFromRedis(request).getUserAccountId());
    }

    @ApiOperation(value = "获取企业实名认证url")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = CompanyVerifyResp.class)})
    @GetMapping("getCompanyVerifyUrl")
    public ResultBody getCompanyVerifyUrl(@ApiParam(value = "端口：0小程序 1后台") @RequestParam Integer port, HttpServletRequest request) {
        return userFddAuthService.getCompanyVerifyUrl(port, this.getUserLoginInfoFromRedis(request));
    }

    @ApiOperation(value = "异步处理企业实名认证")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @ApiIgnore
    @PostMapping("notifyECertRes")
    public ResultBody notifyECertRes(@RequestParam Map<String, String> map) {
        return userFddAuthService.notifyECertRes(map);
    }

//    @ApiOperation(value = "app获取企业实名认证信息")
//    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = AppEVerifyInfoDTO.class)})
//    @GetMapping("findCompanyCertInfo")
//    public ResultBody findCompanyCertInfo(@RequestParam String unionId) {
//        return userFddAuthService.findCompanyCertInfo(unionId);
//    }

//    @ApiOperation(value = "app获取认证信息")
//    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = AppUserFddDTO.class)})
//    @GetMapping("getAppUserFddInfo")
//    public ResultBody<AppUserFddDTO> getAppUserFddInfo(@RequestParam String unionId) {
//        return userFddAuthService.getAppUserFddInfo(unionId);
//    }
//
//    @ApiOperation(value = "app获取认证信息(feign调用)")
//    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = AppUserFddDTO.class)})
//    @ApiIgnore
//    @GetMapping("feignGetAppUserFddInfo")
//    public List<AppUserFddDTO> feignGetAppUserFddInfo(@RequestParam List<String> unionIds) {
//        return userFddAuthService.feignGetAppUserFddInfo(unionIds);
//    }
}
