package com.mmc.iuav.user.service.wallet.impl;

import com.mmc.iuav.response.ResultBody;
import com.mmc.iuav.user.dao.wallet.PayWalletDao;
import com.mmc.iuav.user.entity.wallet.PayWalletDO;
import com.mmc.iuav.user.model.dto.wallet.PayWalletDTO;
import com.mmc.iuav.user.service.wallet.PayWalletService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

/**
 * @Author LW
 * @date 2023/8/18 11:36
 * 概要：
 */
@Service
public class PayWalletServiceImpl implements PayWalletService {
    @Resource
    PayWalletDao payWalletDao;

    @Override
    public ResultBody getPayWalletInfo(Integer userAccountId) {
        PayWalletDO wallet = payWalletDao.getPayWalletByUser(userAccountId);
        if (wallet == null) {
            return null;
        }
        PayWalletDTO pd = wallet.buildPayWalletDTO();
        pd.mathTotal();
        return ResultBody.success(pd);
    }

    @Override
    public ResultBody initPayWallet(Integer userAccountId) {
        PayWalletDO wallet = new PayWalletDO();
        wallet.defaultValue();
        wallet.setUserAccountId(userAccountId);
        payWalletDao.insertPayWalletInfo(wallet);
        return ResultBody.success();
    }
}
