package com.mmc.iuav.user.controller.userpoints.config;


/**
 * @Author small
 * @Date 2023/8/5 11:14
 * @Version 1.0
 */
public enum UserPointsEnum {
    REGISTER(0, "注册"),
    REAL_NAME_AUTHENTICATION(1, "实名认证"),
    PILOT_CERTIFICATION(2, "飞手认证"),
    TOPIC_REWARD(3, "发布话题奖励"),
    SIGN_IN_REWARD(4, "签到"),
    OTHER_CHANGE(5, "其他变动"),
    USER_USE(6, "使用");

    private int code;
    private String message;

    private UserPointsEnum(int code, String message) {
        this.code = code;
        this.message = message;
    }

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public static UserPointsEnum match(int key) {

        UserPointsEnum result = null;

        for (UserPointsEnum s : values()) {
            if (s.getCode() == key) {
                result = s;
                break;
            }
        }

        return result;
    }


}
