package com.mmc.iuav.user.controller;

import com.mmc.iuav.group.Insert;
import com.mmc.iuav.response.ResultBody;
import com.mmc.iuav.user.model.vo.AppUserSucVO;
import com.mmc.iuav.user.model.vo.WxLoginVO;
import com.mmc.iuav.user.service.AuthService;
import com.mmc.iuav.user.service.UserAccountService;
import io.swagger.annotations.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;

/**
 * @author: zj
 * @Date: 2023/5/29 14:37
 */
@Api(tags = "临时登录授权")
@RequestMapping("/temp-auth/")
@RestController
public class TempLoginController extends BaseController{

    @Autowired
    private AuthService authService;

    @ApiOperation(value = "小程序确认登录")
    @ApiResponses({ @ApiResponse(code = 200, message = "OK", response = ResultBody.class) })
    @GetMapping("tempConfirmLogin")
    public ResultBody tempConfirmLogin(HttpServletRequest request, @ApiParam(value = "临时登录code",example = "kj6d9wcxyp92jajugdnc") @RequestParam String randomLoginCode){
        return authService.tempConfirmLogin(this.getUserLoginInfoFromRedis(request), randomLoginCode);
    }

    @ApiOperation(value = "查询登录信息")
    @ApiResponses({ @ApiResponse(code = 200, message = "OK", response = ResultBody.class) })
    @GetMapping("getLoginInfo")
    public ResultBody getLoginInfo(@ApiParam(value = "临时登录code",example = "kj6d9wcxyp92jajugdnc") @RequestParam String randomLoginCode){
        return authService.getLoginInfo(randomLoginCode);
    }




    //test
}
